#if NUNIT
#region Directives
//-----------------------***
using System;
using System.Collections;
using System.Data;
using System.Text;
using NUnit.Framework;
using gov.va.med.vbecs.UnitTest.VAL;
using gov.va.med.vbecs.UnitTests;

using TABLES = gov.va.med.vbecs.Common.VbecsTables;
using SPROCS = gov.va.med.vbecs.Common.VbecsStoredProcs;
using ARTIFICIAL = gov.va.med.vbecs.Common.DatabaseConstants.ArtificialColumnNames;


using BOL = gov.va.med.vbecs.BOL;
using COMMON = gov.va.med.vbecs.Common;
using DAL = gov.va.med.vbecs.DAL;
using VAL = gov.va.med.vbecs.VAL;
using gov.va.med.vbecs.VAL.UnitTests;
//-----------------------***
#endregion

namespace gov.va.med.vbecs.VAL.UnitTests
{
	#region References



	

	#endregion

	[TestFixture]
	public class VAL_VistACache : BaseTest 
	{
		[SetUp]
		protected void SetUp()
		{
			this.BaseSetUp();

			VistALinkUnitTestHarness.RequireConnection();
		}

		[TearDown]
		protected void TearDown()
		{
			VistALinkUnitTestHarness.ReleaseConnection(); 
		}

		[Test]
		public void UpdateCache_Pass()
		{
			int updateRefreshIntervalInMinutes = 15;
			//
			// Test 1:	Delete existing cache (if exists); test insert of all cache tables
			//
			ClearCacheTables();
			//
			DAL.VAL.VistaCache.UpdateCache(updateRefreshIntervalInMinutes);
			//
			// Validate the data was updated
			DataTable dtTemp = UnitTestUtil.RunSQLGetDataTable("SELECT COUNT(*) AS Count FROM CptCache", true);
			Assert.IsTrue( Convert.ToInt32( dtTemp.Rows[0]["Count"] ) > 0 );
			//
			dtTemp = UnitTestUtil.RunSQLGetDataTable("SELECT COUNT(*) AS Count FROM HcpcsCache", true);
			Assert.IsTrue( Convert.ToInt32( dtTemp.Rows[0]["Count"] ) > 0 );
			//
			dtTemp = UnitTestUtil.RunSQLGetDataTable("SELECT COUNT(*) AS Count FROM HospitalLocationCache", true);
			Assert.IsTrue( Convert.ToInt32( dtTemp.Rows[0]["Count"] ) > 0 );
			//
			dtTemp = UnitTestUtil.RunSQLGetDataTable("SELECT COUNT(*) AS Count FROM WorkloadCache", true);
			Assert.IsTrue( Convert.ToInt32( dtTemp.Rows[0]["Count"] ) > 0 );

			// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
			// Test 2:	Since we just updated the cache, verify the cache is NOT
			//			updated if we call UpdateCache a second time within 
			//			updateRefreshIntervalInMinutes

			dtTemp = UnitTestUtil.RunSQLGetDataTable("SELECT TOP 1 LastUpdateDate FROM CptCache ORDER BY LastUpdateDate DESC", true);
			DateTime d11 = Convert.ToDateTime( dtTemp.Rows[0]["LastUpdateDate"] );
			//
			dtTemp = UnitTestUtil.RunSQLGetDataTable("SELECT TOP 1 LastUpdateDate FROM HcpcsCache ORDER BY LastUpdateDate DESC", true);
			DateTime d21 = Convert.ToDateTime( dtTemp.Rows[0]["LastUpdateDate"] );
			//
			dtTemp = UnitTestUtil.RunSQLGetDataTable("SELECT TOP 1 LastUpdateDate FROM HospitalLocationCache ORDER BY LastUpdateDate DESC", true);
			DateTime d31 = Convert.ToDateTime( dtTemp.Rows[0]["LastUpdateDate"] );
			//
			dtTemp = UnitTestUtil.RunSQLGetDataTable("SELECT TOP 1 LastUpdateDate FROM WorkloadCache ORDER BY LastUpdateDate DESC", true);
			DateTime d41 = Convert.ToDateTime( dtTemp.Rows[0]["LastUpdateDate"] );
			//
			DAL.VAL.VistaCache.UpdateCache(updateRefreshIntervalInMinutes);
			//
			dtTemp = UnitTestUtil.RunSQLGetDataTable("SELECT TOP 1 LastUpdateDate FROM CptCache ORDER BY LastUpdateDate DESC", true);
			DateTime d12 = Convert.ToDateTime( dtTemp.Rows[0]["LastUpdateDate"] );
			//
			dtTemp = UnitTestUtil.RunSQLGetDataTable("SELECT TOP 1 LastUpdateDate FROM HcpcsCache ORDER BY LastUpdateDate DESC", true);
			DateTime d22 = Convert.ToDateTime( dtTemp.Rows[0]["LastUpdateDate"] );
			//
			dtTemp = UnitTestUtil.RunSQLGetDataTable("SELECT TOP 1 LastUpdateDate FROM HospitalLocationCache ORDER BY LastUpdateDate DESC", true);
			DateTime d32 = Convert.ToDateTime( dtTemp.Rows[0]["LastUpdateDate"] );
			//
			dtTemp = UnitTestUtil.RunSQLGetDataTable("SELECT TOP 1 LastUpdateDate FROM WorkloadCache ORDER BY LastUpdateDate DESC", true);
			DateTime d42 = Convert.ToDateTime( dtTemp.Rows[0]["LastUpdateDate"] );
			//
			// The dates should be equal ...
			Assert.AreEqual(d11, d12);
			Assert.AreEqual(d21, d22);
			Assert.AreEqual(d31, d32);
			Assert.AreEqual(d41, d42);

			// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
			// Test 3:	Now, set the LastUpdateDate such that an update is forced
			//
			UnitTestUtil.RunSQL("UPDATE CptCache SET LastUpdateDate = DATEADD(HOUR, -1, GETUTCDATE())");
			UnitTestUtil.RunSQL("UPDATE HcpcsCache SET LastUpdateDate = DATEADD(HOUR, -1, GETUTCDATE())");
			UnitTestUtil.RunSQL("UPDATE HospitalLocationCache SET LastUpdateDate = DATEADD(HOUR, -1, GETUTCDATE())");
			UnitTestUtil.RunSQL("UPDATE WorkloadCache SET LastUpdateDate = DATEADD(HOUR, -1, GETUTCDATE())");
			//
			DAL.VAL.VistaCache.UpdateCache(updateRefreshIntervalInMinutes);
			//
			dtTemp = UnitTestUtil.RunSQLGetDataTable("SELECT TOP 1 LastUpdateDate FROM CptCache ORDER BY LastUpdateDate DESC", true);
			d12 = Convert.ToDateTime( dtTemp.Rows[0]["LastUpdateDate"] );
			//
			dtTemp = UnitTestUtil.RunSQLGetDataTable("SELECT TOP 1 LastUpdateDate FROM HcpcsCache ORDER BY LastUpdateDate DESC", true);
			d22 = Convert.ToDateTime( dtTemp.Rows[0]["LastUpdateDate"] );
			//
			dtTemp = UnitTestUtil.RunSQLGetDataTable("SELECT TOP 1 LastUpdateDate FROM HospitalLocationCache ORDER BY LastUpdateDate DESC", true);
			d32 = Convert.ToDateTime( dtTemp.Rows[0]["LastUpdateDate"] );
			//
			dtTemp = UnitTestUtil.RunSQLGetDataTable("SELECT TOP 1 LastUpdateDate FROM WorkloadCache ORDER BY LastUpdateDate DESC", true);
			d42 = Convert.ToDateTime( dtTemp.Rows[0]["LastUpdateDate"] );
			//
			// The new dates should be greater (more recent) ...
			Assert.IsTrue(d11 < d12);
			Assert.IsTrue(d21 < d22);
			Assert.IsTrue(d31 < d32);
			Assert.IsTrue(d41 < d42);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void UpdateCache_Fail()
		{
			
		}

		#region Helper Methods

		/// <summary>
		/// ClearCacheTables
		/// </summary>
		private void ClearCacheTables()
		{
			ArrayList storedProcedures = new ArrayList();
			ArrayList dataTables = new ArrayList();
			//
			// Clear existing cache so we can insert the lastest from VistA
			storedProcedures.Add(SPROCS.ClearCptCache.StoredProcName);
			dataTables.Add(new DataTable());
			//
			storedProcedures.Add(SPROCS.ClearHcpcsCache.StoredProcName);
			dataTables.Add(new DataTable());
			//
			storedProcedures.Add(SPROCS.ClearHospitalLocationCache.StoredProcName);
			dataTables.Add(new DataTable());
			//
			storedProcedures.Add(SPROCS.ClearWorkloadCache.StoredProcName);
			dataTables.Add(new DataTable());
			//
			new Common.StoredProcedure().SimpleTransactionalGetValue(storedProcedures, dataTables);
			//
			// Validate the data was updated
			DataTable dtTemp = UnitTestUtil.RunSQLGetDataTable("SELECT COUNT(*) AS Count FROM CptCache", true);
			int count = Convert.ToInt32( dtTemp.Rows[0]["Count"] );
			//
			dtTemp = UnitTestUtil.RunSQLGetDataTable("SELECT COUNT(*) AS Count FROM HcpcsCache", true);
			count += Convert.ToInt32( dtTemp.Rows[0]["Count"] );
			//
			dtTemp = UnitTestUtil.RunSQLGetDataTable("SELECT COUNT(*) AS Count FROM HospitalLocationCache", true);
			count += Convert.ToInt32( dtTemp.Rows[0]["Count"] );
			//
			dtTemp = UnitTestUtil.RunSQLGetDataTable("SELECT COUNT(*) AS Count FROM WorkloadCache", true);
			count += Convert.ToInt32( dtTemp.Rows[0]["Count"] );
			//
			Assert.IsTrue(count == 0);
		}

		#endregion
	}
}

#endif
